/*
 * Decompiled with CFR 0.152.
 */
package Krasnodar.rockstarnew.systems.notifications;

import Krasnodar.rockstarnew.Rockstar;
import Krasnodar.rockstarnew.systems.event.EventListener;
import Krasnodar.rockstarnew.systems.event.impl.render.HudRenderEvent;
import Krasnodar.rockstarnew.systems.notifications.Notification;
import Krasnodar.rockstarnew.systems.notifications.NotificationOther;
import Krasnodar.rockstarnew.systems.notifications.NotificationType;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import lombok.Generated;

public class NotificationManager {
    private final List<Notification> notifications = new CopyOnWriteArrayList<Notification>();
    private final List<NotificationOther> notificationsOther = new CopyOnWriteArrayList<NotificationOther>();
    private final EventListener<HudRenderEvent> onHudRenderEvent = event -> {
        for (Notification notification : this.notifications) {
            notification.update();
        }
        float off = 0.0f;
        for (NotificationOther notification : this.notificationsOther) {
            notification.update();
            notification.draw(event.getContext(), off);
            if (!(notification.getAnimation().getValue() >= 0.5f) && notification.getTimer().finished(notification.getDuration())) continue;
            off += 30.0f;
        }
        this.notifications.removeIf(Notification::isFinished);
        this.notificationsOther.removeIf(NotificationOther::isFinished);
    };

    public NotificationManager() {
        Rockstar.getInstance().getEventManager().subscribe(this);
    }

    public void addNotification(NotificationType type, String text) {
        this.notifications.add(new Notification(type, text));
    }

    public void addNotificationOther(NotificationType type, String title, String desc) {
        this.notificationsOther.add(new NotificationOther(type, title, desc));
    }

    @Generated
    public List<Notification> getNotifications() {
        return this.notifications;
    }

    @Generated
    public List<NotificationOther> getNotificationsOther() {
        return this.notificationsOther;
    }
}

